// author: RuanShengQiang 
// date: 2017/6/21
#define vec2 float2
#define vec3 float3
#define vec4 float4
#define rgb xyz
#define rgba xyzw
#define PI 3.141592653589f

const sampler_t sampler = CLK_NORMALIZED_COORDS_TRUE | CLK_ADDRESS_CLAMP_TO_EDGE | CLK_FILTER_LINEAR;

vec4 INPUT(image2d_t src_data, __global FilterParam* param, vec2 tc)
{
	tc = (vec2)(tc.x, tc.y)*(vec2)(param->origROI[2], param->origROI[3]) + (vec2)(param->origROI[0], param->origROI[1]);
	return read_imagef(src_data, sampler, (vec2)(tc.x, 1.0f - tc.y));
}

float mySmoothstep(float edge0, float edge1, float x) {
  // Scale, bias and saturate x to 0..1 range
  x = clamp((x - edge0) / (edge1 - edge0), 0.0f, 1.0f); 
  // Evaluate polynomial
  return x * x * (3.0f - 2.0f * x);
}

__kernel void MAIN(__read_only image2d_t input1, __read_only image2d_t input2, __write_only image2d_t dstImg,__global FilterParam* param)
{
		// default a = 4
	float a = 4.0f;
	// default b = 1
	float b = 1.0f;
	// default amplitude = 120
	float amplitude = 120.0f;
	// default smoothness = 0.1
	float smoothness = 0.1f;

	float progress = param->cur_time / param->total_time;
	int W = get_global_size(0);
	int H = get_global_size(1);
	int textH = param->height[2];
	int w = get_global_id(0);
	int h = get_global_id(1);
	float2 resolution = (float2)(W,H);
	int2 gl_FragCoord = (int2)(get_global_id(0), get_global_id(1));
	vec2 fragCoord = (vec2)(get_global_id0( param), get_global_id1( param));
	vec2 p = ((vec2)(fragCoord.x, fragCoord.y) + (vec2)(0.5f)) /resolution.xy;

	vec2 dir = p - (vec2)(.5f);
	float dist = length(dir);
	float x = (a - b) * cos(progress) + b * cos(progress * ((a / b) - 1.f) );
	float y = (a - b) * sin(progress) - b * sin(progress * ((a / b) - 1.f));
	vec2 offset = dir * (vec2)(sin(progress  * dist * amplitude * x), sin(progress * dist * amplitude * y)) / smoothness;
  
	vec4 gl_FragColor = mix(INPUT(input1, param, p + offset), INPUT(input2, param, p), mySmoothstep(0.2f, 1.0f, progress));
	write_imagef(dstImg, (int2)(w, textH - h -1), gl_FragColor);
}